/*------------------------------------------------------------------------------*
 * File Name: Control.h															*
 * Creation: TD 11/12/2002														*
 * Purpose: Origin C support for Windows controls								*
 * Copyright (c) OriginLab Corp.2002											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS									*
 * EJP 2006-11-13 v8.0510 PREVENT_MEM_LEAK_FROM_LBMP							*
 * EJP 2006-11-15 v8.0512 SUPPORT_ITEM_DATA_IN_OC_LISTBOX						*
 * Hong 06/29/07 v.80652 MOVE_WNDCONTAINER_TO_SEPARATE_FILE_FOR_XF_INCLUDE		*
 *	YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP									*
 * Kyle 12/11/2008 ADD_METHOD_TO_GET_TAB_TITLES									*
 * Sim 12-18-2008 QA80-12790-P2 IMPROVE_OC_MENU_CLASS_GET_POPUP_BACK			*
 *	TD 02-11-2009 QA80-13097 OC_RESTET_DLG_MENU									*
 *	Kenny 09/18/2009 QA81-14329 ALLOW_SETTING_SIZE_OF_DROP_DOWN_PORTION_OF_COMBOBOX*
 *	Kyle 11/18/2009 QA80-14691 WANT_DOUBLE_CLICK_TO_HIGHLIGHT_A_WORD_IN_EDIT_BOX*
 *	Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *	Sophy 10/29/2010 ORG-1179 SUPPORT_DISPLAY_COLORED_COLOR_TEXT_ON_LIST		*
 *------------------------------------------------------------------------------*/
#pragma PCH //CPY 12/9/04
#ifndef _CONTROL_H
#define _CONTROL_H

//#include <Common.h>
//#include <String.h>
//#include <Page.h>
//#include <MSWin.h> 
#include <MsgMap.h>
/// Hong 06/29/07 v.80652 MOVE_WNDCONTAINER_TO_SEPARATE_FILE_FOR_XF_INCLUDE
#include <wndContainer.h>
///** >User Interface Controls
//*/
//class WndContainer : public Window
//{
	//
//public:
	//
	///**
	//*/
	//WndContainer();
//};
/// end MOVE_WNDCONTAINER_TO_SEPARATE_FILE_FOR_XF_INCLUDE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Control_(class)
*/
class Control : public Window
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-Control
	*/
	Control();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-Control
	*/
	Control(Control ctrl);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-SetToolTip
	*/
	BOOL SetToolTip(LPCSTR lpcszTxt);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-Value
	*/
	int Value;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-Measure
	*/
	int Measure(LPCSTR lpcszText, int* pWdith, BOOL bSingleLine = false);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-UseSysFont
	*/
	BOOL UseSysFont(int nSysFontType, BOOL bFixedWidth = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Control-InvalidateOnResize
	*/
	BOOL InvalidateOnResize(BOOL bInvalidate = TRUE);

};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Edit_(class)
*/
class Edit : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-Edit
	*/
	Edit();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-Edit
	*/
	Edit(Control ctrl);
	

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-GetSel
	*/
	void GetSel(int& nStartChar, int& nEndChar);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-GetSelText
	*/
	string GetSelText();		

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-SetSel
	*/
	void SetSel(int nStartChar, int nEndChar, BOOL bNoScroll = FALSE);
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-ReplaceSel
	*/
	void ReplaceSel(LPCTSTR lpcszNewText, BOOL bCanUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-LineIndex
	*/
	int LineIndex( int nLine = -1 ) const;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-LineFromChar
	*/
	int LineFromChar( int nIndex = -1 ) const;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-LineLength
	*/
	int LineLength( int nLine = -1 ) const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Edit-GetLineCount
	*/
	int GetLineCount( ) const;

	///Kyle 11/18/2009 QA80-14691 WANT_DOUBLE_CLICK_TO_HIGHLIGHT_A_WORD_IN_EDIT_BOX
	/**$
		Set whether to select one word like vc or the standard behavior of CEdit on user double click the left button of the mouse.
		Return:
			TRUE for success.
	*/
	BOOL SetDbClkSelWord(BOOL bSet = TRUE);
	///End WANT_DOUBLE_CLICK_TO_HIGHLIGHT_A_WORD_IN_EDIT_BOX
	
	///Sophy 6/30/2010 ORG-23-S0 MAKE_EDIT_CONTROL_READONLY_TO_ALLOW_COPY
	/**
		Set edit control's read-only property.
	*/
	BOOL ReadOnly;
	///end MAKE_EDIT_CONTROL_READONLY_TO_ALLOW_COPY
};	


//--------------------------------------------------------------------------
// RichEdit control
//--------------------------------------------------------------------------
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CHARFORMAT
*/
typedef struct _charformat { 
  UINT     cbSize; 
  DWORD    dwMask; 
  DWORD    dwEffects; 
  LONG     yHeight; 
  LONG     yOffset; 
  COLORREF crTextColor; 
  BYTE     bCharSet; 
  BYTE     bPitchAndFamily; 
  char    szFaceName[LF_FACESIZE]; 
} CHARFORMAT;

/* CHARFORMAT masks */
#define CFM_BOLD		0x00000001
#define CFM_ITALIC		0x00000002
#define CFM_UNDERLINE	0x00000004
#define CFM_STRIKEOUT	0x00000008
#define CFM_PROTECTED	0x00000010
#define CFM_LINK		0x00000020		/* Exchange hyperlink extension */
#define CFM_SIZE		0x80000000
#define CFM_COLOR		0x40000000
#define CFM_FACE		0x20000000
#define CFM_OFFSET		0x10000000
#define CFM_CHARSET		0x08000000

/* CHARFORMAT effects */
#define CFE_BOLD		0x0001
#define CFE_ITALIC		0x0002
#define CFE_UNDERLINE	0x0004
#define CFE_STRIKEOUT	0x0008
#define CFE_PROTECTED	0x0010
#define CFE_LINK		0x0020
#define CFE_AUTOCOLOR	0x40000000		/* NOTE: this corresponds to */
										/* CFM_COLOR, which controls it */

/* Event notification masks */
#define ENM_NONE				0x00000000
#define ENM_CHANGE				0x00000001
#define ENM_UPDATE				0x00000002
#define ENM_SCROLL				0x00000004
#define ENM_KEYEVENTS			0x00010000
#define ENM_MOUSEEVENTS			0x00020000
#define ENM_REQUESTRESIZE		0x00040000
#define ENM_SELCHANGE			0x00080000
#define ENM_DROPFILES			0x00100000
#define ENM_PROTECTED			0x00200000
#define ENM_CORRECTTEXT			0x00400000		/* PenWin specific */
#define ENM_SCROLLEVENTS		0x00000008
#define ENM_DRAGDROPDONE		0x00000010

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit_(class)
*/
class RichEdit : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-RichEdit
	*/
	RichEdit();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-RichEdit
	*/
	RichEdit(Control ctrl);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetSelectionCharFormat
	*/
	BOOL SetSelectionCharFormat(CHARFORMAT& cf);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetSel
	*/
	void GetSel(long& nStartChar, long& nEndChar);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetSel
	*/
	void SetSel(long nStartChar, long nEndChar);
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-ReplaceSel
	*/
	void ReplaceSel(LPCTSTR lpszNewText, BOOL bCanUndo = FALSE);
			
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetSelText
	*/
	string GetSelText();		
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetReadOnly
	*/
	BOOL SetReadOnly(BOOL bReadOnly = TRUE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetFirstVisibleLine
	*/
	int GetFirstVisibleLine();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetModify
	*/
	BOOL GetModify();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetModify
	*/
	void SetModify(BOOL bModified = TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetDefaultCharFormat
	*/
	BOOL SetDefaultCharFormat(CHARFORMAT& cf);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetSelectionCharFormat
	*/
	DWORD GetSelectionCharFormat(CHARFORMAT& cf);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetDefaultCharFormat
	*/
	DWORD GetDefaultCharFormat(CHARFORMAT& cf);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetTextColor
	*/
	BOOL SetTextColor(long nStartChar, long nEndChar, COLORREF cr);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-LineIndex
	*/
	int LineIndex( int nLine = -1 ) const;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-LineFromChar
	*/
	long LineFromChar( long nIndex = -1) const;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetLine
	*/
	string GetLine( int nIndex = -1) const;


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-LineLength
	*/
	int LineLength( int nLine = -1 ) const;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetLineCount
	*/
	int GetLineCount( ) const;

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-LineScroll
	*/
	void LineScroll( int nLines, int nChars = 0 );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-LimitText
	*/
	void LimitText( long nChars = 0 );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-GetLimitText
	*/
	long GetLimitText( ) const;

		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Write
	*/
	bool Write(LPCSTR lpcstr);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Load
	*/
	bool Load(LPCSTR lpcszFile);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Save
	*/
	bool Save(LPCSTR lpcszFile);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Reset
	*/
	bool Reset();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-WriteLine
	*/
	int WriteLine(LPCSTR lpcstr = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-AutoComplete
	*/
	BOOL AutoComplete(int nStartIndex, StringArray &saOptions, vector<int> &vnAttributes = NULL, BOOL bSort = TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Copy
	*/
	void Copy();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Paste
	*/
	void Paste();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-Print
	*/
	BOOL Print(int nUseDialog, LPCSTR lpcszName);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:RichEdit-SetTextBkColor
	*/
	BOOL SetTextBkColor(long nStartChar, long nEndChar, COLORREF cr);



};	

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Slider_(class)
*/
class Slider : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-Slider
	*/
	Slider();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-Slider
	*/
	Slider(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-Position
	*/
	int 	Position;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-RangeMax
	*/
	int 	RangeMax;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-RangeMin
	*/
	int 	RangeMin;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Slider-SetTicFreq
	*/
	void 	SetTicFreq(int freq);

};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls_(class)
*/
class OriginControls : public Control
{
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-OriginControls
	*/
	OriginControls();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-OriginControls
	*/
	OriginControls(Control ctrl);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-GetPage
	*/
	Page 	GetPage();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-Create
	*/
	BOOL		Create(DWORD dwNoClickBits = NOCLICK_USE_DEFAULT, LPCSTR lpcszTemplateName=NULL);	  

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-CreateControl
	*/
	BOOL		CreateControl(HWND hWnd);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-AttachPage
	*/
	BOOL 		AttachPage(Page &page, DWORD dwNoClickBits = NOCLICK_USE_DEFAULT);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-DetachPage
	*/
	BOOL		DetachPage();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginControls-EditInOriginWorkspace
	*/
	BOOL EditInOriginWorkspace(LPCSTR lpcszClassName, int nPercent);
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GraphControl_(class)
*/
class GraphControl : public OriginControls
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphControl-GraphControl
	*/
	GraphControl();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphControl-GraphControl
	*/
	GraphControl(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphControl-GetPage
	*/
	GraphPage 	GetPage();


};	

/**# >User Interface Controls
*/
class MatrixControl : public OriginControls
{
public:

	/**#
	*/
	MatrixControl();
	
	/**#
	*/
	MatrixControl(Control ctrl);
	
	/**#
		Return:
		 Returns the Matrix page
		Example:
		bool DisplayProper( MatrixControl& omc)
		{
			int nSize = 20;
			MatrixPage mp = omc.GetPage(); // Get page
			MatrixLayer ml = mp.Layers();  // Get active layer
			MatrixObject mo = ml.MatrixObjects();
			mo.SetInternalData(FSI_BYTE,TRUE,FALSE);
			mo.SetDimensions(nSize,nSize);
			matrixbase &mb = mo.GetDataObject();
			for(int ii = 0; ii < nSize; ii++)
			{
				for(int jj = 0; jj < nSize; jj++)
				{
					
					mb[ii][jj] = sqrt(ii*ii + jj*jj + 1);
				}
			}
			ml.SetViewImage();

			
			
			return true;
		}
		//Calling/Creating	
		Control splitterPlaceHolder1  = GetItem( IDC_TWOGRAPHS_GRAPH1 );
		HWND hWnd = splitterPlaceHolder1.GetSafeHwnd();
		MatrixControl  omc;
		omc.CreateControl(hWnd);

		omc.Create();
		Worksheet wks = Project.ActiveLayer();
		Curve cc1( wks, 0, 1 ); 
		DisplayProper(m_gpControl1);
		Remarks:
			You must create an Origin Matrix. Typically this is done in the OnInitDialog function.
	*/
	MatrixPage 	GetPage();

	/**
		Create the Origin Matrix inside the control window
		Parameters:
			dwNoClickBits = options to disable clicking on various components on a graph
			lpcszTemplateName = template name. If no path is specified, will assume the Origin path. NULL will use Origin.otp.

		Return:
			TRUE for success.
		Example:
	*/
	//BOOL		Create(DWORD dwNoClickBits = NOCLICK_USE_DEFAULT, LPCSTR lpcszTemplateName=NULL);	  
	//BOOL		CreateControl(HWND hWnd);
	

};	


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl_(class)
*/
class WorksheetControl : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-WorksheetControl
	*/
	WorksheetControl();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-WorksheetControl
	*/
	WorksheetControl(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-Attach
	*/
	BOOL Attach(LPCSTR lpcszWorksheetName);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-Update
	*/
	void Update();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetColInfo
	*/
	BOOL GetColInfo( int nCol, int& nType, int& nDesignation );	

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-SetColDesignations
	*/
	BOOL	SetColDesignations(LPCSTR lpcszDesignations, BOOL bRepeat = TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetColDesignations
	*/
	string	GetColDesignations();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetColDesignations
	*/
	void	GetColDesignations(string& strDesignations);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-SetColFormats
	*/
	BOOL	SetColFormats(LPCSTR lpcszFormats, BOOL bRepeat = TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetColFormats
	*/
	string	GetColFormats();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetColFormats
	*/
	void	GetColFormats(string& strFormats);	

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-RemoveAllItems
	*/
	void RemoveAllItems();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-CreateControl
	*/
	BOOL CreateControl(HWND hWnd);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-SetHeadingType
	*/
	BOOL SetHeadingType(int nShow);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetControl-GetHeaderingType
	*/
	int GetHeaderingType();
	
	///Sophy 10/29/2010 ORG-1179 SUPPORT_DISPLAY_COLORED_COLOR_TEXT_ON_LIST
#ifdef	__NEW_DATABASEIMPORTDLG__
	/**#
		This function set the column background color when it is not highlighted.
	*/
	BOOL	SetColumnColor(int nCol, COLORREF color);
	/**#
		This function get the column background color when it is not highlighted.
	*/
	BOOL	GetColumnColor(int nCol, COLORREF& color);
	/**#
		This function set the column width by specify the number of characters to display.
	*/
	BOOL	SetColumnWidth(int nCol, int nChars);
	/**#
		This function get the number of characters visible in specified column.
	*/
	BOOL	GetColumnWidth(int nCol, int& nChars);
#endif	//__NEW_DATABASEIMPORTDLG__
	///end SUPPORT_DISPLAY_COLORED_COLOR_TEXT_ON_LIST
	
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Button_(class)
*/
class Button : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Button-Button
	*/
	Button();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Button-Button
	*/
	Button(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Button-Check
	*/
	int	Check;
};


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:BitmapRadioButton_(class)
*/
class BitmapRadioButton : public Button
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitmapRadioButton-BitmapRadioButton
	*/
	BitmapRadioButton();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitmapRadioButton-BitmapRadioButton
	*/
	BitmapRadioButton(Control ctrl);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitmapRadioButton-Init
	*/
	BOOL Init(UINT nStates, UINT nBmpResID, UINT nBmpSliceWidth, vector<string> & vstrTips, UINT nBmpOffset = 0);
	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
	/**$
	When set to true, the button shows as pusshed down at all times;
	*/
	BOOL PressedDown;
	/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
};


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox_(class)
*/
class ComboBox : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-ComboBox
	*/
	ComboBox();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-ComboBox
	*/
	ComboBox(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-GetCurSel
	*/
	int 	GetCurSel() const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-SetCurSel
	*/
	void 	SetCurSel(int nSelect);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-GetCount
	*/
	int		GetCount() const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-GetLBText
	*/
	void	GetLBText(int nIndex, string& str)	const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-AddString
	*/
	int 	AddString(LPCSTR lpcsz);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-InsertString
	*/
	int 	InsertString(int nIndex, LPCSTR lpcsz);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-DeleteString
	*/
	int 	DeleteString(int nIndex);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-SetItemData
	*/
	int		SetItemData(int nIndex, DWORD dwData);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-GetItemData
	*/
	DWORD	GetItemData(int nIndex) 	const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-ResetContent
	*/
	void	ResetContent();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ComboBox-SelectString
	*/
	int		SelectString(int nStartAfter, LPCSTR lpcsz); 

	/// Kenny 09/18/2009 QA81-14329 ALLOW_SETTING_SIZE_OF_DROP_DOWN_PORTION_OF_COMBOBOX
	// Comments last updated by Kenny on 09/18/2009
	/**+
		Remarks:
			Call this function to retrieve the minimum allowable width, in pixels, of the list box of a combo box. 
			This function only applies to combo boxes with the CBS_DROPDOWN or CBS_DROPDOWNLIST style.
		Example1:
			int GetDroppedWidth_ex1()
			{
				ComboBox  cmbBox = MyDlg.GetItem(IDC_COMBO1);
				int nWidth = cmbBox.GetDroppedWidth();
				return 0;
			}
		Return:
			If successful, the minimum allowable width, in pixels; otherwise, -1.
	*/
	int		GetDroppedWidth()	const;

	// Comments last updated by Kenny on 09/18/2009
	/**+
		Remarks:
			Call this function to set the minimum allowable width, in pixels, of the list box of a combo box. 
			This function only applies to combo boxes with the CBS_DROPDOWN or CBS_DROPDOWNLIST style.
		Example1:
			int SetDroppedWidth_ex1()
			{
				ComboBox  cmbBox = MyDlg.GetItem(IDC_COMBO1);
				int nWidth = cmbBox.GetDroppedWidth();
				cmbBox.SetDroppedWidth( nWidth * 2 );
				return 0;
			}
		Parameters:
			nWidth = [input] The minimum allowable width of the list-box portion of the combo box, in pixels.
		Return:
			If successful, the new width of the list box, otherwise -1.
	*/
	int		SetDroppedWidth(int nWidth);

	// Comments last updated by Kenny on 09/18/2009
	/**+
		Remarks:
			Call this function to set the visible item count when the list box of a combo box was pulled down.
		Example1:
			int SetDroppedVisibleItemCount_ex1()
			{
				ComboBox  cmbBox = MyDlg.GetItem(IDC_COMBO1);
				cmbBox.SetDroppedVisibleItemCount();
				return 0;
			}
		Parameters:
			nItemCount = [input] The number of visible items, to make all items visible use COMBOBOX_DROPPED_ALL_ITEMS_VISIBLE.
			bRepaint = [input] Specifies whether the control is to be repainted
	*/
	void	SetDroppedVisibleItemCount(int nItemCount = COMBOBOX_DROPPED_ALL_ITEMS_VISIBLE, BOOL bRepaint = TRUE);
	/// End QA81-14329 ALLOW_SETTING_SIZE_OF_DROP_DOWN_PORTION_OF_COMBOBOX
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ListBox_(class)
*/
class ListBox : public Control
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-ListBox
	*/
	ListBox();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-ListBox
	*/
	ListBox(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetCurSel
	*/
	int 	GetCurSel() const;	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-SetCurSel
	*/
	void 	SetCurSel(int nSelect);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetCount
	*/
	int		GetCount() const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetText
	*/
	void	GetText(int nIndex, string& str);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-AddString
	*/
	int 	AddString(LPCSTR lpcsz);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-InsertString
	*/
	int 	InsertString(int nIndex, LPCSTR lpcsz);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-DeleteString
	*/
	int 	DeleteString(int nIndex);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-ResetContent
	*/
	void	ResetContent();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-CopyAll
	*/
	int		CopyAll(ListBox &lbSource, BOOL bCopyAllAlways, int nPos);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-CopySel
	*/
	int		CopySel(ListBox &lbSource, BOOL bCopyAllAlways, int nPos);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-MoveAll
	*/
	int		MoveAll(ListBox &lbSource, BOOL bCopyAllAlways, int nPos);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-MoveSel
	*/
	int		MoveSel(ListBox &lbSource, BOOL bCopyAllAlways, int nPos);

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetSelCount
	*/
	int		GetSelCount();


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetSelItems
	*/
	int		GetSelItems(vector<uint>& vv);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetSel
	*/
	int		GetSel(int nIndex);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-SetSel
	*/
	int		SetSel(int nIndex, BOOL bSelect = TRUE);

	/// EJP 2006-11-15 v8.0512 SUPPORT_ITEM_DATA_IN_OC_LISTBOX
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-SetItemData
	*/
	int		SetItemData(int nIndex, DWORD dwData);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ListBox-GetItemData
	*/
	DWORD	GetItemData(int nIndex) 	const;
	/// end SUPPORT_ITEM_DATA_IN_OC_LISTBOX
};



#define MF_STRING           0x00000000L
#define MF_ENABLED          0x00000000L
#define MF_GRAYED           0x00000001L
#define MF_DISABLED         0x00000002L
#define MF_UNCHECKED        0x00000000L
#define MF_CHECKED          0x00000008L
#define MF_POPUP            0x00000010L
#define MF_SEPARATOR        0x00000800L

#define MF_BYCOMMAND        0x00000000L
#define MF_BYPOSITION       0x00000400L



/*
 * Flags for TrackPopupMenu
 */
#define TPM_LEFTBUTTON  0x0000L
#define TPM_RIGHTBUTTON 0x0002L
#define TPM_LEFTALIGN   0x0000L
#define TPM_CENTERALIGN 0x0004L
#define TPM_RIGHTALIGN  0x0008L
#define TPM_NOTIFY		0x1000L

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Menu_(class)
*/
class Menu
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Menu
	*/
	Menu();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Menu
	*/
	Menu(Menu& menu);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Menu
	*/
	Menu(HINSTANCE hInst, int nID, int nPos);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Menu
	*/
	Menu(HMENU hMenu);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Load
	*/
	BOOL Load(HINSTANCE hInst, int nID, int nPos);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Load
	*/
	BOOL Load(HMENU hMenu);
	/// end OC_RESTET_DLG_MENU
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Add
	*/
	BOOL	Add(LPCSTR lpcszText, Function fnHandler, UINT nFlags = MF_STRING, int nMenuID = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Add
	*/
	BOOL	Add(LPCSTR lpcszText, int nCmdID, UINT nFlags = MF_STRING);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-InsertMenu
	*/
	BOOL	InsertMenu(LPCTSTR lpcszNewItem, UINT nPosition, Function fnHandler, UINT nFlags = MF_STRING);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-InsertMenu
	*/
	BOOL	InsertMenu(UINT nPosition, UINT nFlags,  UINT nIDNewItem = 0, LPCTSTR lpcszNewItem = NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-ModifyMenu
	*/
	BOOL	ModifyMenu(UINT nPosition, UINT nFlags, UINT nIDNewItem = 0, LPCTSTR lpcszNewItem = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-RemoveMenu
	*/
	BOOL	RemoveMenu(UINT nPosition, UINT nFlags);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Create
	*/
	BOOL	Create(BOOL bEmptyAsFromResource = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-TrackPopupMenu
	*/
	BOOL	TrackPopupMenu(UINT nFlags,  int x, int y, HWND hwnd, int *pnCmdSelected = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-TrackPopupResMenu
	*/
	int		TrackPopupResMenu(UINT nFlags,  int x, int y, HWND hwnd);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-GetOwnerWindow
	*/
	Window	GetOwnerWindow();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-GetMenuItemID
	*/
	int		GetMenuItemID(uint nPos);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-GetSafeHmenu
	*/
	HWND	GetSafeHmenu();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-AddPopup
	*/
	BOOL	AddPopup(LPCSTR lpcszText, Menu& menu, int nBeginId = -1);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-InsertPopup
	*/
	BOOL	InsertPopup(UINT nPosition, LPCSTR lpcszText, Menu& menu, int nBeginId = -1);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-Detach
	*/
	HMENU	Detach();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-DeleteMenu
	*/
	BOOL	DeleteMenu(UINT nPosition, UINT nFlags);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-GetMenuString
	*/
	int		GetMenuString(UINT nIDItem, string& rString, UINT nFlags);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-RemoveAllItems
	*/
	int		RemoveAllItems();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-BeginPopup
	*/
	BOOL	BeginPopup(LPCSTR lpcszTxt);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-EndPopup
	*/
	BOOL	EndPopup();
	
	///---Sim 12-18-2008 QA80-12790-P2 IMPROVE_OC_MENU_CLASS_GET_POPUP_BACK
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Menu-GetPopupHmenu
	*/
	HWND	GetPopupHmenu(UINT nCmdIDChild);
	///---END QA80-12790-P2 IMPROVE_OC_MENU_CLASS_GET_POPUP_BACK
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:TabControl_(class)
*/
class TabControl : public Control
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-TabControl
	*/
	TabControl();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-TabControl
	*/
	TabControl(Control ctrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-InsertItem
	*/
	BOOL InsertItem(int nItem, LPCSTR lpcszTxt);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-GetCurSel
	*/
	int  GetCurSel();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-SetCurSel
	*/
	int  SetCurSel(int nItem);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-DeleteItem
	*/
	BOOL DeleteItem(int nItem);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-DeleteAllItems
	*/
	BOOL DeleteAllItems();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-AdjustRect
	*/
	void AdjustRect(BOOL bLarger, RECT *lpRect);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-GetItemRect
	*/
	BOOL GetItemRect(int nIndex, RECT *lpRect);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-SetItemText
	*/
	BOOL SetItemText(int nIndex, LPCSTR lpcszTitle);
	
	///Kyle 12/11/2008 ADD_METHOD_TO_GET_TAB_TITLES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TabControl-GetItemText
	*/
	string GetItemText(int nIndex);
	///End ADD_METHOD_TO_GET_TAB_TITLES
};
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OCOLOR
*/
#define OCOLOR   uint
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl_(class)
*/
class PictureControl : public Control
{

public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-PictureControl
	*/
	PictureControl();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-PictureControl
	*/
	PictureControl(Control pict);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-CreateControl
	*/
	BOOL CreateControl(HWND hWndHolder);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetPicture
	*/
	BOOL SetPicture(PictureHolder &pic);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetBitMap
	*/
	BOOL SetBitMap(HBITMAP hBmp, BOOL bTakeOwnership = TRUE); 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetIcon
	*/
	BOOL SetIcon(HICON hIcon, BOOL bTakeOwnership = TRUE);  

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetMetaFile
	*/
	BOOL SetMetaFile(HMETAFILE hMetafile, int nExtX, int nExtY, BOOL bTakeOwnership = TRUE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetEnhMetaFile
	*/
	BOOL SetEnhMetaFile(HENHMETAFILE hEnhMetafile, BOOL bTakeOwnership = TRUE); 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetDIB
	*/
	BOOL SetDIB(HDIB hDib);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetLeadBitmap
	*/
	/// EJP 2006-11-13 v8.0510 PREVENT_MEM_LEAK_FROM_LBMP
	///BOOL SetLeadBitmap(LPVOID pLBmp);
	BOOL SetLeadBitmap(LPVOID pLBmp, BOOL bTakeOwnership = FALSE);
	/// end PREVENT_MEM_LEAK_FROM_LBMP
	 
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetBackgroundColor
	*/
	void SetBackgroundColor(OCOLOR color);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-SetBorderColor
	*/
	void SetBorderColor(OCOLOR color);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-DrawMode
	*/
	int  DrawMode;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PictureControl-KeepAspectRatio
	*/
	bool KeepAspectRatio;
	
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton_(class)
*/
class	SpinButton	:	public	Control
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-SpinButton
	*/
	SpinButton();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-SpinButton
	*/
	SpinButton(Control spinBtn);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-SetBase
	*/
	int		SetBase(int nBase);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-GetBase
	*/
	int		GetBase();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-SetPos
	*/
	int		SetPos(int nPos);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-GetPos
	*/
	int		GetPos();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-SetRange
	*/
	void	SetRange(int nLower, int nUpper);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:SpinButton-GetRange
	*/
	void	GetRange(int& nLower, int& nUpper);
};


/// TD 2-5-05 TOOLBAR_CONTROL_IN_OC
/// Comments last updated by Cloud 03/15/2007
/**# >
*/
class ToolBar : public Control
{
public:
	ToolBar();
	ToolBar(Control control);

	BOOL LoadToolBar(UINT nIDResource, HINSTANCE hResInst = NULL);
	UINT GetButtonStyle(int nIndex) const;
	void SetButtonStyle(int nIndex, UINT nStyle);
 	BOOL CreateControl(HWND hWnd);
 	void RePosition();

};
/// end TOOLBAR_CONTROL_IN_OC

///Comments last updated by Joseph 04/04/2007
/// TD 2-16-04 QA70-7368 CODE_EDITOR_IN_DIALOG
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit_(class)
*/
class CodeEdit : public RichEdit
{  
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-CodeEdit
	*/
	CodeEdit();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-CodeEdit
	*/
	CodeEdit(Control control);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-SetText
	*/
	bool SetText(LPCSTR lpcszText);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-GetText
	*/
	bool GetText(string & strText);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-CreateControl
	*/
	bool CreateControl(HWND hWndParent, RECT& rect, int nID);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-CreateControl
	*/
	bool CreateControl(HWND hWndHolder);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-Highlight
	*/
	void Highlight(int nLine);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-ColorOptions
	*/
	void ColorOptions(DWORD dwColorOpions);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CodeEdit-AddKeywords
	*/
	void AddKeywords(StringArray &saKeywords);
};

/// end CODE_EDITOR_IN_DIALOG


/// TD 6-29-05 QA70-7810 DLL_CONTROLED_WINDOW
/**# >
*/
class CustomCotrol : public   Control
{
public:
	/**
	default constructor
	*/
	CustomCotrol();
	/**
		constructor, copy and creats from base class object
	Parameters:
		control : source object, from which the new object is created
	*/
	CustomCotrol(Control control);


	/**
		Associates a dll name and and a function name with the control
	Parameters:
		lpcszDllName : The name of the dll that contains the function
		lpcszFunctionName : The name of the function that is designated to be called to override the WindowProc
	Return:
		returns true if successful else false
	*/
	BOOL SetControl(LPCSTR lpcszDllName, LPCSTR lpcszFunctionName);
	/**
		creates a control using the holder attributes, destroys the holder window
	Parameters:
		hwndHolder : the created control uses the rect and ID from the holder. The holder itself is destroyed.
	Return:
		returns true if successful else false
	*/
	BOOL CreateControl(HWND hwndHolder);
	/**
		Frees a dll if not in use. Helpful for development without closing origin
	Parameters:
		lpcszDllName : name of the dll to be freed, if null uses the name associalted to the object via SetControl method
	Return:
		returns true if successful else false
	*/
	BOOL FreeLibrary(LPCSTR lpcszDllName = NULL);
};
/// end DLL_CONTROLED_WINDOW

/// TD 3-2-06 QA70-8490 DYNACONTROL_EVENT_FUNCTION_PTR
typedef bool (* PDYNAEVENT_FUNC)(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg); //CPY 5/30/03 added getNDlg
/// end DYNACONTROL_EVENT_FUNCTION_PTR

//-----Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
/*
//----- CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
// strAux added CPY 10/10/06 QA70-9039 XF_WIZARD_BAR
// strErrMsg added CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
typedef bool (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, bool& bOKEnable, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
typedef int (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, bool& bOKEnable, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
//-----
*/
typedef int (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
//------End GETN_BOX_ADD_APPLY_BUTTON

//CPY 5/30/03 added getNDlg
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl_(class)
*/
class DynaControl : public   Control
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-DynaControl
	*/
	DynaControl();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-DynaControl
	*/
	DynaControl(Control control);  
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-SetTree
	*/
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	//BOOL SetTree(TreeNode &node, DWORD dwOptions = 0);
	BOOL SetTree(TreeNode &node, DWORD dwOptions = 0, int nDisplaySubNode = -1);
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-CreateControl
	*/
	BOOL CreateControl(HWND hwndHolder, DWORD dwCreateOptions = 0);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-Reset
	*/
	BOOL Reset();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnSelectionChange
	*/
	BOOL	OnSelectionChange();
	
	/// YuI 07/19/06 PROPER_INTERACTIVE_DROP_DOWN_FOR_MATRIX_OBJECT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnChangePage
	*/
	BOOL	OnChangePage();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnChangeLayer
	*/
	BOOL	OnChangeLayer();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnChangeDataset
	*/
	BOOL	OnChangeDataset();
	/// end PROPER_INTERACTIVE_DROP_DOWN_FOR_MATRIX_OBJECT

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnSelectionTrack
	*/
	BOOL	OnSelectionTrack();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionOk
	*/
	BOOL	OnDSSelectionOk();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionCancel
	*/
	BOOL	OnDSSelectionCancel();
	
	
	/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionChangeEx
	*/
	BOOL	OnDSSelectionChangeEx(uint wParam, uint lParam);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionTrackEx
	*/
	BOOL	OnDSSelectionTrackEx(uint wParam, uint lParam);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionOkEx
	*/
	BOOL	OnDSSelectionOkEx(uint wParam, uint lParam);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSSelectionCancelEx
	*/
	BOOL	OnDSSelectionCancelEx(uint wParam, uint lParam);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSMarkerCreate
	*/
	BOOL	OnDSMarkerCreate(uint wParam, uint lParam);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-OnDSMarkerDestroy
	*/
	BOOL	OnDSMarkerDestroy(uint wParam, uint lParam);
	/// end DATA_MARKERS_REVAMP

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-InvokeHandlers
	*/
	int	InvokeHandlers(DWORD dwControl = 0);
	
	/**$
	*/
	string m_strErrMsgSenderTagName;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-SetEventCallback
	*/
	BOOL 	SetEventCallback(PDYNAEVENT_FUNC pfnEvent, PEVENT_GETN pfnNew = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-GetTreeNode
	*/

	TreeNode   GetTreeNode(int nRow, int nCol = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-GetActiveTreeNode
	*/

	TreeNode   GetActiveTreeNode(int &nRow, int &nCol = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-GetOptimalSize
	*/
	BOOL GetOptimalSize(SIZE& size);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-GetChild
	*/
	BOOL GetChild(Window &WndDlg, int nIndex = -1);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-Update
	*/
	BOOL Update(DWORD dwOptions = 0);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-GetCollapsed
	*/
	int GetCollapsed(vector<byte>& vn, bool bOnlyTopLevelIsBranch = true, bool bIncludeChildren = false );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-SetCollapsed
	*/
	bool SetCollapsed(const vector<byte>& vn, bool bOnlyTopLevelIsBranch = true, bool bExpandParents = false);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-AbjustFocusToSave
	*/
	void AbjustFocusToSave();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DynaControl-bInvokeEvents
	*/
	BOOL bInvokeEvents;


};



/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl_(class)
*/
class WizardControl :public   Control
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-WizardControl
	*/
	WizardControl();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-WizardControl
	*/
	WizardControl(Control control);  
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-CreateControl
	*/
	BOOL CreateControl(HWND hwndHolder);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-AddStep
	*/
	int AddStep(LPCSTR stepLabel, LPCSTR comboString = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-InsertStep
	*/
	int InsertStep(LPCSTR stepLabel, LPCSTR comboString = NULL, int nIndex = -1);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-GetActiveStep
	*/
	int GetActiveStep(string *pStrCombo = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-SetActiveStep
	*/
	int SetActiveStep(int nIndex, string *pStrCombo = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-GetNumSteps
	*/
	int  GetNumSteps();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-UpdateStep
	*/
	BOOL UpdateStep(int nIndex, LPCSTR  stepLabel, LPCSTR comboString = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-GetComboSelection
	*/
	int GetComboSelection(int nIndex, string *pstrSel = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-SetComboSelection
	*/
	BOOL SetComboSelection(int nIndex, string &strComboString);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-SetComboSelection
	*/
	BOOL SetComboSelection(int nIndex, int nIndexSelection);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-EnableCombo
	*/

	BOOL EnableCombo(int nIndex, BOOL bEnable = TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-ShowCombos
	*/

	BOOL ShowCombos(BOOL bShow = FALSE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-SetEventHandler
	*/
	BOOL SetEventHandler(ClassObject objEventHandler);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-IsStepVisible
	*/
	BOOL IsStepVisible(int nIndex);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-ShowStep
	*/
	int ShowStep(int nIndex, BOOL bShow = FALSE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-ShowCombo
	*/
	int ShowCombo(int nIndex, BOOL bShow = FALSE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardControl-IsComboVisible
	*/
	BOOL IsComboVisible(int nIndex);



};


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ColorText_(class)
*/
class ColorText : public Control
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-ColorText
	*/
	ColorText();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-ColorText
	*/
	ColorText(Control control);  
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-CreateControl
	*/
	BOOL CreateControl(HWND hwndHolder);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-SetBold
	*/
	void SetBold(BOOL bBold);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-SetTxtColor
	*/
	void SetTxtColor(COLORREF crColor);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-SetTxtBlink
	*/
	void SetTxtBlink(COLORREF crColor1, COLORREF crColor2);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-SetBkBlink
	*/
	void SetBkBlink(COLORREF crColor1, COLORREF crColor2);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-SetBkColor
	*/
	void SetBkColor(COLORREF crColor);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-BlinkText
	*/
	void BlinkText(DWORD dwCtrl);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ColorText-BlinkBackground
	*/
	void BlinkBackground(DWORD dwCtrl);

};

#endif //_CONTROL_H
